<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\DepartmentController;
use App\Http\Controllers\EmployeeController;
use App\Http\Controllers\CompanyController;
use App\Http\Controllers\CustomFieldController;
use App\Http\Controllers\VisitController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\ActivityController;
use App\Http\Middleware\UserAuth;
use App\Models\company_user;
use App\Models\company;
use App\Http\Controllers\DropdownController;
use Illuminate\Http\Request;
Route::get('/landing/{company}', function ($company) {
    return view('landing', ['company' => $company]);
});
Route::get('/verify-otp', function () {
    return view('admin.verify_otp');
});
Route::post('/api/otp-verify', [AuthController::class, 'verifyOtp'])->name('api.verifyOtp');
Route::get('/checkout', function () {
    return view('checkout');
})->name('checkout');

Route::get('/auto-login/{host_id}/{visit_id}', [VisitController::class, 'autoLogin'])
    ->name('visit.autoLogin');

//////// api links
Route::get('/users/{encoded}', [VisitController::class, 'show']);

Route::get('/api/activity-logs', [ActivityController::class, 'index']);

Route::get('/api/check-session', [AuthController::class, 'checkSession']);

Route::get('/auth/admin-login', function () {
    return view("admin.login");
})->name('admin.login');
Route::match(['get', 'post'], '/api/admin-login', [AuthController::class, 'login'])->name('api.admin.login');
Route::post('/user/logout', [AuthController::class, 'logout'])->name('logout');
//  Route::group(['middleware'=>['user_auth']], function(){
Route::prefix("department")->group(function()
{
        Route::match(['get', 'post'], 'add', [DepartmentController::class, 'add'])->name('department.add');
      Route::get('list', [DepartmentController::class, 'list'])->name('department.list');
    Route::delete('delete/{id}', [DepartmentController::class, 'delete'])->name('department.delete');
    Route::get('show/{id}', [DepartmentController::class, 'show']);
    Route::put('update/{id}', [DepartmentController::class, 'update']);
    // Route::get('/places', [DepartmentController::class, 'places']);

});
Route::prefix('employee')->group(function () {
    Route::match(['get', 'post'], 'add', [EmployeeController::class, 'add'])->name('employee.add');
    Route::get('list', [EmployeeController::class, 'list'])->name('employee.list');
    Route::delete('delete/{id}', [EmployeeController::class, 'delete'])->name('employee.delete');
    Route::get('show/{id}', [EmployeeController::class, 'show']);
    Route::put('update/{id}', [EmployeeController::class, 'update']);
  Route::post('/response', [VisitController::class, 'respond']);
});
Route::prefix('custom-fields')->group(function () {
    Route::get('/list', [CustomFieldController::class, 'list'])->name('custom_fields.list');
    Route::get('/show/{id}', [CustomFieldController::class, 'show'])->name('custom_fields.show');
    Route::post('/add', [CustomFieldController::class, 'store'])->name('custom_fields.store');
    Route::put('/update/{id}', [CustomFieldController::class, 'update'])->name('custom_fields.update');
    Route::delete('/delete/{id}', [CustomFieldController::class, 'destroy'])->name('custom_fields.destroy');
    Route::get('/manage', [CustomFieldController::class, 'index'])->name('custom_fields.manage');
    Route::get('/groups/list', [CustomFieldController::class, 'groupList'])->name('custom_field_groups.list');
    Route::post('/groups/add', [CustomFieldController::class, 'groupStore'])->name('custom_field_groups.store');
    Route::delete('/groups/delete/{id}', [CustomFieldController::class, 'groupDestroy'])->name('custom_field_groups.destroy');
    Route::get('/groups/{group}/custom-fields', [CustomFieldController::class, 'getGroupFields']);
});
Route::prefix('visits')->group(function () {
Route::get('/my-visits', [EmployeeController::class, 'myVisits']);
Route::get('/create', [VisitController::class, 'create'])->name('visitors.create');
Route::post('/visitors', [VisitController::class, 'store'])->name('visitors.store');
Route::get('/{id}/profile', [VisitController::class, 'profile']);
Route::get('/check-email', [VisitController::class, 'check_visitor']);
Route::match(['get','post'],'/all-visits', [VisitController::class, 'allCompanyVisits']);
});
Route::prefix('company')->group(function () {
       Route::post('/add',[CompanyController::class, 'add'])->name('company.add');
Route::get('/list', [CompanyController::class, 'list']);
Route::delete('/delete/{id}', [CompanyController::class, 'delete']);
    Route::get('/show/{id}', [CompanyController::class, 'show']);
  Route::put('/update/{external_id}', [CompanyController::class, 'update']);

});
Route::prefix('places')->group(function () {
    Route::match(['get', 'post'], 'add', [DropdownController::class, 'add'])->name('places.add');
    Route::delete('delete/{id}', [DropdownController::class, 'delete'])->name('places.delete');
    Route::get('list', [DropdownController::class, 'list'])->name('places.list');

});
Route::prefix('visit-types')->group(function () {
    Route::get('list', [DropdownController::class, 'visit_types_list'])->name('visit-types.list');
});
Route::prefix('visit-reasons')->group(function () {
    Route::get('list', [DropdownController::class, 'visit_reasons_list'])->name('visit-reasons.list');
});
Route::get('/company-name', function (Request $request) {
    $externalId = $request->query('external_id');
    $company = $externalId
        ? company::where('external_id', $externalId)->first()
        : company::find(session('company_id'));

    return response()->json($company);
});
Route::get('/api/dashboard', [EmployeeController::class, 'dashboard'])->name('api.dashboard');
Route::get('/{any}', function () { return view('admin.master'); })->where('any','^(?!api).*$');
Route::get('/my-profile', [EmployeeController::class, 'my_profile']);
Route::get('/api/hosts', [EmployeeController::class, 'getHosts']);
Route::get('/api/departments', [DepartmentController::class, 'getDepartments']);
Route::get('/api/session-info', function () {
    return response()->json([
        'super_admin_id' => session('super_admin_id'),
        'company_id'     => session('company_id'),
        'user_type'      => session('user_type'),
    ]);
});
