<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('visits', function (Blueprint $table) {
            // Drop existing foreign key if it exists
            $table->dropForeign(['host_id']);

            // Re-add the foreign key to company_users
            $table->foreign('host_id')
                ->references('id')
                ->on('company_users')
                ->onDelete('cascade')
                ->onUpdate('cascade');
        });
    }

    public function down(): void
    {
        Schema::table('visits', function (Blueprint $table) {
            // Rollback: drop the new constraint
            $table->dropForeign(['host_id']);

            // Restore the old constraint to users
            $table->foreign('host_id')
                ->references('id')
                ->on('users')
                ->onDelete('cascade')
                ->onUpdate('cascade');
        });
    }
};
