<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('visitors', function (Blueprint $table) {
            $table->string('whatsapp')->nullable()->after('phone')->comment('WhatsApp Number');
                $table->string('purpose_of_visit')->nullable()->after('whatsapp');
              $table->unsignedBigInteger('host_id')->nullable()->after('purpose_of_visit');
            $table->foreign('host_id')->references('id')->on('company_users')->onDelete('set null');
        });
    }

    public function down(): void
    {
         Schema::table('visitors', function (Blueprint $table) {
            $table->dropForeign(['host_id']);
            $table->dropColumn('host_id');
            $table->dropColumn('whatsapp');
        });
    }
};
