<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('visitor_custom_field_values', function (Blueprint $table) {
            $table->id();

            // Foreign key to visitors table
            $table->unsignedBigInteger('visitor_id');
            $table->foreign('visitor_id')
                  ->references('id')
                  ->on('visitors')
                  ->onDelete('cascade');

            // Foreign key to custom_fields table
            $table->unsignedBigInteger('custom_field_id');
            $table->foreign('custom_field_id')
                  ->references('id')
                  ->on('custom_fields')
                  ->onDelete('cascade');

            // Store the visitor's answer
            $table->text('field_value')->nullable();

            // Optional: keep track of company (if multi-company setup)
            $table->unsignedBigInteger('company_id')->nullable();
            $table->foreign('company_id')
                  ->references('id')
                  ->on('companies')
                  ->onDelete('set null');

            // Optional metadata
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('visitor_custom_field_values');
    }
};
