<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('custom_fields', function (Blueprint $table) {
            $table->id(); // Primary Key
            $table->string('external_id')->nullable()->unique();
            $table->unsignedBigInteger('company_id'); // FK → companies
            $table->string('field_name'); // Internal reference (e.g. "vehicle_number")
            $table->string('field_label'); // Display label (e.g. "Vehicle Number")
            $table->enum('field_type', [
                'text', 
                'number', 
                'email', 
                'date', 
                'time', 
                'textarea', 
                'select', 
                'checkbox', 
                'radio', 
                'file'
            ])->default('text'); // Input type
            $table->boolean('is_required')->default(false);
            $table->integer('order_no')->default(0);
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->timestamps();

            // Foreign key constraint
            $table->foreign('company_id')
                  ->references('id')
                  ->on('companies')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('custom_fields');
    }
};
