<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('visits', function (Blueprint $table) {
            $table->id(); // Primary Key
            $table->string('external_id')->nullable()->unique();
            $table->unsignedBigInteger('company_id'); // FK → companies
            $table->unsignedBigInteger('visitor_id'); // FK → visitors
            $table->unsignedBigInteger('host_id')->nullable(); // FK → users (employee hosting the visitor)
            $table->text('purpose')->nullable();
            $table->date('visit_date')->nullable();
            $table->time('checkin_time')->nullable();
            $table->time('checkout_time')->nullable();
            $table->enum('status', [
                'requested',     // visitor requested visit
                'approved',      // approved by host or admin
                'rejected',      // rejected by host or admin
                'checked_in',    // visitor checked in
                'checked_out',   // visitor checked out
                'cancelled'      // cancelled before visit
            ])->default('requested');
            $table->unsignedBigInteger('approval_by')->nullable(); // FK → users (approved/rejected by)
            $table->timestamp('approval_time')->nullable();
            $table->string('qr_code')->nullable(); // stores QR code path or token
            $table->text('remarks')->nullable();
            $table->timestamps();

            // Foreign Keys
            $table->foreign('company_id')
                  ->references('id')
                  ->on('companies')
                  ->onDelete('cascade');

            $table->foreign('visitor_id')
                  ->references('id')
                  ->on('visitors')
                  ->onDelete('cascade');

            $table->foreign('host_id')
                  ->references('id')
                  ->on('users')
                  ->onDelete('set null');

            $table->foreign('approval_by')
                  ->references('id')
                  ->on('users')
                  ->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('visits');
    }
};
