<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('company_users', function (Blueprint $table) {
             $table->id(); // Primary Key
            $table->string('external_id')->nullable()->unique();
            $table->unsignedBigInteger('company_id'); // FK to companies
            // $table->string('name');
            $table->string('email')->unique();
            $table->string('user_type')->nullable(); // e.g., admin, staff, hr, etc.
            $table->string('designation')->nullable();
            $table->unsignedBigInteger('department')->nullable(); // FK to departments
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->timestamps();

            // Foreign key constraints
            $table->foreign('company_id')
                  ->references('id')
                  ->on('companies')
                  ->onDelete('cascade');

            $table->foreign('department')
                  ->references('id')
                  ->on('departments')
                  ->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('company_users');
    }
};
