<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator;
use App\Models\company;
use App\Models\dropdown_option;

class DropdownController extends Controller
{
    public function add(Request $req)
    {
        if ($req->isMethod('post')) {
            $validator = Validator::make($req->all(), [
                'name' => 'required|string|max:49',
                'status' => 'required|in:active,inactive',
            ]);

            if ($validator->fails()) {
                if ($req->ajax()) {
                    return response()->json(['errors' => $validator->errors()], 422);
                }
                return redirect()->back()->withErrors($validator)->withInput();
            }

            $option = new dropdown_option();

            $option->company_id = session('company_id');
            $option->name = $req->name;
            $option->type = $req->type;
            $option->status = $req->status;
            $option->save();

            $type = ucfirst($req->type);

            if ($option->save()) {
                return response()->json(['message' => $type . ' created successfully!']);
            }

            return redirect()->back()->with('success', ' Something went wrong!');
        }
    }
public function list(Request $request)
{
    $search = $request->query('search');
    $companyId = session('company_id');
    $paginate = $request->query('paginate', false); // check if pagination requested

    $query = dropdown_option::where('type', 'place')
        ->where('company_id', $companyId)
        ->when($search, function ($q) use ($search) {
            $q->where('name', 'like', "%{$search}%")
              ->orWhere('status', 'like', "%{$search}%");
        })
        ->orderBy('id', 'desc');

    if ($paginate) {
        $perPage = $request->query('per_page', config('app.pagination', 10));
        $places = $query->paginate($perPage);

        return response()->json([
            'places' => $places->items(),
            'pagination' => [
                'current_page' => $places->currentPage(),
                'last_page' => $places->lastPage(),
                'per_page' => $places->perPage(),
                'total' => $places->total(),
            ],
            'message' => 'Places fetched successfully.',
        ]);
    } else {
        $places = $query->get(['id', 'name', 'status', 'company_id', 'type']);

        return response()->json([
            'places' => $places,
            'message' => 'Places fetched successfully.',
        ]);
    }
}


public function visit_types_list(Request $request)
{
    $search = $request->query('search');
    $externalId = $request->query('external_id');
    $paginate = $request->query('paginate', false);
    $companyId = session('company_id');
    if (!$companyId && $externalId) {
        $company = company::where('external_id', $externalId)->first();
        if ($company) $companyId = $company->id;
    }

    if (!$companyId) {
        return response()->json(['types' => []], 404);
    }

    $query = dropdown_option::where('type', 'visit_type')
        ->where('company_id', $companyId)
        ->when($search, function ($q) use ($search) {
            $q->where('name', 'like', "%{$search}%")
              ->orWhere('status', 'like', "%{$search}%");
        })
        ->orderBy('id', 'desc');

    if ($paginate) {
        $perPage = $request->query('per_page', config('app.pagination', 10));
        $types = $query->paginate($perPage);
        return response()->json([
            'types' => $types->items(),
            'pagination' => [
                'current_page' => $types->currentPage(),
                'last_page' => $types->lastPage(),
                'per_page' => $types->perPage(),
                'total' => $types->total(),
            ],
            'message' => 'Visit types fetched successfully.',
        ]);
    } else {
        $types = $query->get(['id','name','status','company_id','type']);
        return response()->json([
            'types' => $types,
            'message' => 'Visit types fetched successfully.',
        ]);
    }
}


public function visit_reasons_list(Request $request)
{
    $search = $request->query('search');
    $externalId = $request->query('external_id');
    $paginate = $request->query('paginate', false); // <-- check if pagination requested

    $companyId = session('company_id');

    if (!$companyId && $externalId) {
        $company = company::where('external_id', $externalId)->first();
        if ($company) {
            $companyId = $company->id;
        }
    }

    if (!$companyId) {
        return response()->json([
            'reasons' => [],
            'pagination' => [
                'current_page' => 1,
                'last_page' => 1,
                'per_page' => 10,
                'total' => 0,
            ]
        ], 404);
    }

    $query = dropdown_option::where('type', 'visit_reason')
        ->where('company_id', $companyId)
        ->when($search, function ($q) use ($search) {
            $q->where('name', 'like', "%{$search}%")
              ->orWhere('status', 'like', "%{$search}%");
        })
        ->orderBy('id', 'desc');

    if ($paginate) {
        $perPage = $request->query('per_page', config('app.pagination', 10));
        $reasons = $query->paginate($perPage);

        return response()->json([
            'reasons' => $reasons->items(),
            'pagination' => [
                'current_page' => $reasons->currentPage(),
                'last_page' => $reasons->lastPage(),
                'per_page' => $reasons->perPage(),
                'total' => $reasons->total(),
            ],
            'message' => 'Visit reasons fetched successfully.',
        ]);
    } else {
        $reasons = $query->get(['id','name','status','company_id','type']);

        return response()->json([
            'reasons' => $reasons,
            'message' => 'Visit reasons fetched successfully.',
        ]);
    }
}



    public function delete($id)
    {
        // return $id;
        $option = dropdown_option::where('id',$id)->first();
        if (!$option) {
            return response()->json(['message' => 'Option not found.'], 404);
        }

        $option->delete();

        return response()->json(['message' => 'Option deleted successfully!']);
    }
}
