<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\company_user;
use App\Models\company;
use App\Models\dropdown_option;
use App\Models\system_notification;
use App\Models\notification_setting;
use App\Http\Classes\MyAuth;
use App\Http\Classes\Generic;
use Illuminate\Support\Facades\Log;
use Exception;
use App\Http\Traits\SystemMail;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
class CompanyController extends Controller
{
    use SystemMail;
    public function view(Request $req)
    {
        $query = company::query();
        if ($req->input("name")) {
            $query->where("name", "like", "%" . $req->name . "%");
        }
        if ($req->input("email")) {
            $query->where("email", "=",  $req->email);
        }
        if ($req->input("status") && $req->input("status") != "") {
            $query->where("status", $req->status);
        }
        if ($req->input('poc')) {
            $poc = $req->input('poc');
            $query->where(function ($query) use ($poc) {
                $query->where('POC1', 'like', "%$poc%")
                      ->orWhere('POC2', 'like', "%$poc%");
            });
        }
        $query->withCount("get_users","get_templates")->orderBy('id', 'desc');
        $companies = $query->paginate(config('app.paginate'));
        $filters = $req->all();

        return view('companies.view', compact('companies','filters'));
    }
   public function add(Request $req)
    {
        if (!$req->isMethod('post')) {
            return response()->json(['message' => 'Invalid request method.'], 405);
        }

        $rules = [
            'name' => 'required|string|max:255',
            'first_name' => 'required|string|max:255',
            'last_name' => 'required|string|max:255',
            'email' => 'required|email|unique:company_users,email|unique:companies,email',
            'phone' => 'required|regex:/^[1-9]\d{1,3}[0-9\s\-\(\)]{6,14}$/|min:10|max:15|unique:companies,phone',
            'country' => 'required|string',
            'city' => 'required|string',
            'address' => 'required|string',
            'postal_code' => 'required|string',
            'poc1' => 'required|string',
            'poc2' => 'nullable|string',
            'description' => 'nullable|string',
            'state' => 'required|min:3|max:30',
        ];

        $validator = Validator::make($req->all(), $rules);

        if ($validator->fails()) {
            return response()->json([
                'message' => 'Validation Failed!',
                'errors' => $validator->errors(),
            ], 422);
        }

        try {
            $validatedData = $validator->validated();
            $externalId = Generic::generate_id("cmp");

            $company = new company();
                    $company->name = $validatedData['name'];
                    $company->email = $validatedData['email'];
                    $company->phone=$validatedData['phone'];
                    $company->country=$validatedData['country'];
                    $company->city=$validatedData['city'];
                       $company->state=$validatedData['state'];
                    $company->address=$validatedData['address'];
                    $company->postal_code=$validatedData['postal_code'];
                    $company->poc1=$validatedData['poc1'];
                    $company->poc2=$validatedData['poc2'];
                    $company->description = $validatedData['description'];
                    $company->external_id = $externalId;
                    $company->registered_at = now();
                    $company->status="active";
            $company->save();
            $this->seed_dropdown($company->id);
            $employee = new company_user();
                $employee->external_id  = Generic::generate_id('emp');
                $employee->company_id   = $company->id;
                $employee->first_name   = $req->first_name;
                $employee->last_name    = $req->last_name;
                $employee->email        = $req->email;
                $employee->phone        = $req->phone;
                $employee->state        = $req->state;
                $employee->country      = $req->country;
                $employee->city         = $req->city;
                $employee->address      = $req->address;
                $employee->designation  = $req->designation;
                $employee->status       = "active";
                $employee->user_type    = 'employee';

                $password = Str::upper(Str::random(6));
                $employee->password     = $password;
               if($employee->save()){
                $this->mail_content['subject'] = "Your Company Has Been Successfully Created!";
                $this->mail_content['short_description'] = "Congratulations! Your company setup is complete.";
                $this->mail_content['link'] = config("app.domain") . "auth/admin-login";

                $this->mail_content['content'] = "
                    Congratulations <b>{$employee->first_name}</b>!<br><br>
                    Your company <b>{$company->name}</b> has been successfully created.<br> on " . date("d M Y H:i A") . ".<br><br>
                    <b>Login Details:</b><br>
                    Email: <b>{$employee->email}</b><br>
                    Password: <b>{$password}</b><br><br>
                    Please use the button below to log in and start managing your company.<br>
                ";

                $this->mail_content['link2'] = config("app.domain") . "auth/admin-login";

                $this->mail_users = array();
                $users = array($employee->id);
                $session_data = session()->all();

                dispatch(function () use ($session_data, $users) {
                    $this->mail_users = $this->get_users_by_id($this->mail_content, $users, $this->mail_users, ['session_data' => $session_data]);
                    $this->send_to_members($this->mail_users, ['session_data' => $session_data]);
                })->delay(now()->addSeconds(config("app.queue_time")));
                }


            $password = substr(str_shuffle('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'), 1, 6);


            return response()->json([
                'success' => true,
                'message' => 'Company has been created successfully!',
            ], 200);

        } catch (\Exception $e) {
            Log::error('Company creation failed: ' . $e->getMessage());
            return response()->json([
                'success' => false,
                'message' => 'Server Error: ' . $e->getMessage(),
            ], 500);
        }
    }
private function seed_dropdown($company_id)
{
    $visitReasons = [
        'Meeting with staff or management',
        'Conducting internal audit or compliance review',
        'Product demonstration or business discussion',
        'Performing external compliance inspection',
        'Performing maintenance or installation work',
        'General visit or miscellaneous purpose',
    ];

    $visitTypes = [
        'visitor',
        'auditor',
        'customer',
        'regulatory Auditor',
        'contractor',
        'other',
        'general',
    ];

    foreach ($visitReasons as $reason) {
        $option = new dropdown_option();
        $option->company_id = $company_id;
        $option->type = 'visit_reason';
        $option->name = $reason;
        $option->status="active";
        $option->save();
    }
    foreach ($visitTypes as $type) {
        $option = new dropdown_option();
        $option->company_id = $company_id;
        $option->type = 'visit_type';
        $option->name = $type;
        $option->status="active";
        $option->save();
    }
}

   public function list(Request $request)
    {
        // die("fwef");
        $search = $request->query('search');
        $paginate = $request->query('paginate', false);

        $perPage = config('app.pagination', 10);

        $query = company::orderBy('id', 'desc');

        if (!empty($search)) {
            $query->where(function ($q) use ($search) {
                $q->where('name', 'LIKE', "%{$search}%")
                ->orWhere('email', 'LIKE', "%{$search}%")
                ->orWhere('phone', 'LIKE', "%{$search}%");
            });
        }

        if ($paginate) {
            $companies = $query->paginate($perPage, [
                'id', 'name', 'email', 'phone', 'country', 'status', 'external_id'
            ]);

            return response()->json([
                'companies' => $companies->items(),
                'pagination' => [
                    'current_page' => $companies->currentPage(),
                    'last_page' => $companies->lastPage(),
                    'per_page' => $companies->perPage(),
                    'total' => $companies->total(),
                ],
                'message' => 'Companies fetched successfully (paginated).',
            ]);
        } else {
            $companies = $query->get([
                'id', 'name', 'email', 'phone', 'country', 'status', 'external_id'
            ]);

            return response()->json([
                'companies' => $companies,
                'message' => 'All companies fetched successfully.',
            ]);
        }
    }

  public function show($id)
    {
        $company = company::where('external_id',$id)->first();
        return response()->json(['company' => $company]);
    }

public function update(Request $request, $external_id)
{
      $company =company::where('external_id',$external_id)->first();
    $validated = $request->validate([
        'name' => 'required',
   'email'         => [
                'required',
                'email',
                'max:255',
                Rule::unique('companies')->ignore($company->id),
            ],
        'phone' => 'required',
        'country' => 'required',
        'state' => 'required',
        'city' => 'required',
        'postal_code' => 'required',
        'address' => 'required',
        'poc1' => 'required',
    ]);


      $company->name = $request->name;
                    $company->email = $request->email;
                    $company->phone=$request->phone;
                    $company->country=$request->country;
                    $company->city=$request->city;
                      $company->state=$request->state;
                    $company->address=$request->address;
                    $company->postal_code=$request->postal_code;
                    $company->poc1=$request->poc1;
                    $company->poc2=$request->poc2;
                    $company->description =$request->description;
            $company->save();

    return response()->json(['message' => 'Company updated successfully!']);
}

  public function delete($id)
{
    $company = company::find($id);

    if (!$company) {
        return response()->json(['message' => 'Company not found.'], 404);
    }

    $company->delete();

    return response()->json(['message' => 'Company deleted successfully!']);
}

    public function profile($id){
        $company= company::where('external_id', $id)->withCount("get_templates","get_users")
                        ->firstOrFail();
        $templates = $company->get_templates()->with('get_category')->get();
        return view('companies.profile',compact('company','templates'));
    }
    public function viewUsers(Request $req){
        $query=company_user::query();
        if ($req->input("name") && $req->input("name") != "")
        {
            $query->where("first_name", "like", "%" . $req->name . "%")->orWhere("last_name", "like", "%" . $req->name . "%");
        }
        if ($req->input("email1") && $req->input("email1") != "")
        {
            $query->where("email", "like", "%" . $req->email1 . "%");
        }
        if ($req->input("status") && $req->input("status") != "") {
            $query->where("status", $req->status);
        }
        if ($req->input("company_id") && $req->input("company_id") != "") {
            $query->whereHas('get_companies', function($q) use ($req) {
                $q->where('company_id', $req->company_id);
            });
        }
        $users=$query->orderBy('id', 'desc')->paginate(config('app.paginate'));
        $filters = $req->all();
        return view('companies.users-list',compact('users','filters'));
    }
    public function editUser(Request $req,$id){
        if ($req->method() == "POST") {

            $id=$req->input('user_id');
            $user =company_user::where('external_id',$id)->first();

            if(!$user)
            {
               return redirect()->back()->with(['response_class' => 'danger', 'response_status' => 'false', 'response_message' => "User Not Found. Please try again."]);
            }
            // return $req->all();
             $req->validate([
                 'first_name' => 'required|min:3|max:30',
                 'last_name' => 'required|min:3|max:30',
                 'country' => 'required|min:3|max:30',
                 'city' => 'required|min:3|max:30',
                 'phone' => [
                    'required',
                    'regex:/^[1-9]\d{1,3}[0-9\s\-\(\)]{6,14}$/',
                    'min:10',
                    'max:15',
                    Rule::unique('user_profiles', 'phone')->ignore($user->get_profile->id, 'id'),
                ],
                'status'=>'required|in:active,blocked',
                 'postal_code' => 'required|min:3|max:30',

             ]);

             try{
                 $user->first_name = $req->first_name;
                 $user->last_name = $req->last_name;
                 $user->status=$req->status;
                 if ($user->save()) {

                     $profile =user_profile::where('company_user_id',$user->id)->first();
                     $profile->country = $req->country;
                     $profile->city = $req->city;
                     $profile->postal_code = $req->postal_code;
                     $profile->phone = $req->phone;
                     $profile->address = $req->address;

                     if ($profile->save()) {

                         return redirect()->route('company-users.edit',$user->external_id)->with(['response_class' => 'success', 'response_status' => 'true', 'response_message' => "Information has been successfully updated."]);
                     } else {
                         return redirect()->back()->with(['response_class' => 'danger', 'response_status' => 'false', 'response_message' => "Something went wrong. Please try again."]);
                     }
                 } else {
                     return redirect()->back()->with(['response_class' => 'danger', 'response_status' => 'false', 'response_message' => "Something went wrong. Please try again."]);
                 }
             }
             catch(Exception $e)
             {

                 return redirect()->back()->with(['response_class' => 'danger', 'response_status' => 'false', 'response_message' => "Something went wrong.".$e->getMessage()]);
             }
         }
        $user=company_user::where('external_id',$id)->with('get_profile')->first();
        return view('companies.edit-user',compact('user'));
    }
    public function userProfile($id)
    {

        $user=company_user::where('external_id',$id)->with('get_profile','get_roles')->first();
        if(!$user)
        {
            return redirect()->back()->with(['response_class' => 'danger', 'response_status' => 'false', 'response_message' => "User not found. Please try again."]);
        }
        return view('companies.user_profile',compact('user'));
    }
}
