<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\company_user;
use App\Models\company;
use App\Models\user_cookie;
use App\Http\Traits\SystemMail;
use Illuminate\Support\Str;

class AuthController extends Controller
{
        use SystemMail;
public function login(Request $req)
{
    $req->validate([
        'email'    => 'required|email',
        'password' => 'required|string|max:20',
    ]);
    // return $req;
    $user = company_user::where('email', $req->email)
        ->first();

    if (!$user || $user->password !== $req->password) {
        return response()->json([
            'status'  => false,
            'message' => 'Invalid email or password.',
        ], 401);
    }
    if ($user->block_status === 'true' || $user->status === 'blocked') {
        return response()->json([
            'status'  => false,
            'message' => 'Your account has been blocked. Contact administrator.',
        ], 403);
    }
    $cookieVal = $req->cookie('testing');
    $existingCookie = user_cookie::where('user_id', $user->id)
        ->orderBy('id', 'desc')
        ->first();
    if ($cookieVal && $existingCookie &&
        $existingCookie->cookie === $cookieVal &&
        $existingCookie->cookie_expiry > now())
    {


        if ($user->user_type == 'super_admin') {
        $req->session()->put('user_name', (string) $user->first_name .''. $user->last_name);
              session([
            'super_admin_id'    => $user->id,
            'user_type'         => 'super_admin',
            'super_admin_email' => $user->email,
        ]);
            $redirect = '/company/manage';
            $message = 'Super Admin login successful.';
        } elseif ($user->user_type == 'employee') {

                $req->session()->put('comp_user_id', $user->id);
        $req->session()->put('user_type', 'company_user');
     $req->session()->put('user_name', (string) $user->first_name .''. $user->last_name);
     $company = company::where('id',$user->company_id)->first();

        if ($company) {

            $req->session()->put('company_id', $company->id);
            $req->session()->put('company_name', $company->name);
        }
            $redirect = '/dashboard';
            $message = 'Company user login successful.';
        } else {
            $redirect = '/login';
            $message = 'Not Registered.';
        }
        return response()->json([
            'status'   => true,
            'message'  => $message,
            'redirect' => $redirect,
            'user'     => $user,
        ]);

    }
    $otp = rand(100000, 999999);
    $expiry = now()->addMinutes(10);

    $user->otp   = $otp;
    $user->otp_expire = $expiry;
    $user->save();
    $req->session()->put('user_email',$user->email);

    $this->dispatchOtpMail($user, $otp);
    return response()->json([
        'status'   => true,
        'message'  => 'OTP sent to your registered email.',
        'redirect' => "/verify-otp",
    ]);
}
protected function dispatchOtpMail($user, $otp)
{
    $this->mail_content['subject'] = 'Your Secure One Time Password (OTP)';
                $this->mail_content['short_description'] = 'Do not share it with anyone.';
                $this->mail_content['link'] = 'verification';
                $this->mail_content['content'] = 'Your one time password is: <br><span style="font-size: 24px; font-weight: bold; color:rgb(12, 109, 15);">' . $otp . '</span>';
                $this->mail_content['link2'] =  config("app.domain") . "verification";
                $this->mail_users = array();

               $users = array();
                $users[] = $user->id;

                $session_data = session()->all();
                    dispatch(
                        function () use ($users,$session_data) {
                            $this->mail_users = $this->get_users_by_id($this->mail_content, $users, $this->mail_users,['session_data'=>$session_data]);
                            $this->send_to_members($this->mail_users,['session_data'=>$session_data,'type'=>'reseller']);
                        }
                 )->delay(now()->addSeconds(config("app.queue_time")));
                 session()->flash('login_msg', 'We have sent you One Time Password to your registered email');
}

public function logout(Request $req)
{
    $req->session()->forget([
        'comp_user_id',
        'comp_user_name',
        'company_id',
    ]);
    $req->session()->invalidate();
    $req->session()->regenerateToken();
    return response()->json([
        'status' => true,
        'message' => 'Logout successful.',
    ]);
}
public function checkSession(Request $request)
{
    // Check if user is in OTP verification process
    $otpPending = session('otp_verification_pending');
    $userEmail = session('user_email');

    if ($otpPending && $userEmail) {
        return response()->json([
            'authenticated' => false,
            'otp_pending' => true
        ], 200);
    }

    $comp_user_id = session('comp_user_id');
    $super_admin_id = session('super_admin_id');

    if (!$comp_user_id && !$super_admin_id) {
        return response()->json(['authenticated' => false], 401);
    }

    $user_id = $comp_user_id ?? $super_admin_id;
    $user = company_user::find($user_id);

    if (!$user) {
        return response()->json(['authenticated' => false], 401);
    }

    if ($user->block_status === 'true' || $user->status === 'blocked') {
        return response()->json([
            'authenticated' => false,
            'blocked' => true
        ], 403);
    }

    return response()->json([
        'authenticated' => true,
        'user' => $user,
        'type' => $user->type ?? 'company_user',
    ]);
}
  public function verifyOtp(Request $req)
{
    $email = session('user_email');
    $user = company_user::where('email', $email)->first();

    if (!$user) {
        return response()->json([
            'status'  => false,
            'message' => 'User not found.'
        ]);
    }

    if ($user->otp == $req->otp) {
        $minutes = 28800;
        $cook = Str::upper(Str::random(10));
        cookie()->queue(cookie('testing', $cook, $minutes));

        $expiry_date = now()->addDays(30)->format('Y-m-d');
        $cookie = new user_cookie();
        $cookie->cookie = $cook;
        $cookie->cookie_expiry = $expiry_date;
        $cookie->user_id = $user->id;
        $cookie->save();

        if ($user->user_type === 'super_admin') {
              session([
            'super_admin_id'    => $user->id,
            'user_type'         => 'super_admin',
            'super_admin_email' => $user->email,
        ]);
                         $req->session()->put('user_name', (string) $user->first_name .''. $user->last_name);
            $redirect = '/company/manage';
            $message = 'Super Admin login successful.';
        } elseif ($user->user_type === 'employee') {
               $req->session()->put('comp_user_id', $user->id);
                 $req->session()->put('user_name', (string) $user->first_name .''. $user->last_name);
             $company = company::where('id', $user->company_id)->first();
            if ($company) {

                     $req->session()->put('company_id', $company->id);
                $req->session()->put('company_name', (string) $company->name);
            }
            $redirect = '/dashboard';
            $message = 'Login successful.';
        } else {
            $redirect = '/login';
            $message = 'Registeration Not Found.';
        }
        return response()->json([
            'status'   => true,
            'message'  => $message,
            'redirect' => $redirect,
            'user'     => $user,
        ]);
    } else {
        session()->flash('login_msg', 'OTP is invalid or expired.');
        return response()->json([
            'status'  => false,
            'message' => 'OTP is invalid or expired.',
        ]);
    }
}

}
