<?php

namespace App\Http\Classes;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
//include public_path('phpqrcode/qrlib.php');

class Barcode
{
    public static function generate($param)
    {
        // return "<h2>Hello</h2>";
        // return $param;
        $filepath = (isset($param["filepath"]) ? $param["filepath"] : "");
        $text = (isset($param["text"]) ? $param["text"] : "0");
        $size = (isset($param["size"]) ? $param["size"] : "50");
        $orientation = (isset($param["orientation"]) ? $param["orientation"] : "horizontal");
        $code_type = (isset($param["codetype"]) ? $param["codetype"] : "code128");
        $print = (isset($param["print"]) ?  $param["print"] : true);
        $sizefactor = (isset($param["sizefactor"]) ? $param["sizefactor"] : "1");

         $pre = self::barcode($filepath, $text, $size, $orientation, $code_type, $print, $sizefactor);
         return "data:image/png;base64,".base64_encode($pre->getContent());
    }

    public static function barcode($filepath = "", $text = "0", $size = "20", $orientation = "horizontal", $code_type = "code128", $print = false, $SizeFactor = 1)
    {
        $code_string = "";

        // Translate the $text into barcode of the correct $code_type
        if (in_array(strtolower($code_type), ["code128", "code128b"])) {
            $chksum = 104;
            // Must not change the order of array elements as the checksum depends on the array's key to validate the final code
            $code_array = [
                " " => "212222", "!" => "222122", "\"" => "222221", "#" => "121223", "$" => "121322", "%" => "131222",
                "&" => "122213", "'" => "122312", "(" => "132212", ")" => "221213", "*" => "221312", "+" => "231212",
                "," => "112232", "-" => "122132", "." => "122231", "/" => "113222", "0" => "123122", "1" => "123221",
                "2" => "223211", "3" => "221132", "4" => "221231", "5" => "213212", "6" => "223112", "7" => "312131",
                "8" => "311222", "9" => "321122", ":" => "321221", ";" => "312212", "<" => "322112", "=" => "322211",
                ">" => "212123", "?" => "212321", "@" => "232121", "A" => "111323", "B" => "131123", "C" => "131321",
                "D" => "112313", "E" => "132113", "F" => "132311", "G" => "211313", "H" => "231113", "I" => "231311",
                "J" => "112133", "K" => "112331", "L" => "132131", "M" => "113123", "N" => "113321", "O" => "133121",
                "P" => "313121", "Q" => "211331", "R" => "231131", "S" => "213113", "T" => "213311", "U" => "213131",
                "V" => "311123", "W" => "311321", "X" => "331121", "Y" => "312113", "Z" => "312311", "[" => "332111",
                "\\" => "314111", "]" => "221411", "^" => "431111", "_" => "111224", "`" => "111422", "a" => "121124",
                "b" => "121421", "c" => "141122", "d" => "141221", "e" => "112214", "f" => "112412", "g" => "122114",
                "h" => "122411", "i" => "142112", "j" => "142211", "k" => "241211", "l" => "221114", "m" => "413111",
                "n" => "241112", "o" => "134111", "p" => "111242", "q" => "121142", "r" => "121241", "s" => "114212",
                "t" => "124112", "u" => "124211", "v" => "411212", "w" => "421112", "x" => "421211", "y" => "212141",
                "z" => "214121", "{" => "412121", "|" => "111143", "}" => "111341", "~" => "131141", "DEL" => "114113",
                "FNC 3" => "114311", "FNC 2" => "411113", "SHIFT" => "411311", "CODE C" => "113141", "FNC 4" => "114131",
                "CODE A" => "311141", "FNC 1" => "411131", "Start A" => "211412", "Start B" => "211214", "Start C" => "211232",
                "Stop" => "2331112"
            ];

            $code_keys = array_keys($code_array);
            $code_values = array_flip($code_keys);

            for ($X = 1; $X <= strlen($text); $X++) {
                $activeKey = substr($text, ($X - 1), 1);
                $code_string .= $code_array[$activeKey];
                $chksum = ($chksum + ($code_values[$activeKey] * $X));
            }

            $code_string .= $code_array[$code_keys[($chksum - (intval($chksum / 103) * 103))]];

            $code_string = "211214" . $code_string . "2331112";
        } elseif (strtolower($code_type) == "code128a") {
            // Code128A logic
            // ...

            $code_string = "211412" . $code_string . "2331112";
        } elseif (strtolower($code_type) == "code39") {
            // Code39 logic
            // ...

            $code_string = "1211212111" . $code_string . "121121211";
        } elseif (strtolower($code_type) == "code25") {
            // Code25 logic
            // ...

            $code_string = "1111" . $code_string . "311";
        } elseif (strtolower($code_type) == "codabar") {
            // Codabar logic
            // ...

            $code_string = "11221211" . $code_string . "1122121";
        }

        // Pad the edges of the
        // Pad the edges of the barcode
        $code_length = 20;
        if ($print) {
            $text_height = 30;
        } else {
            $text_height = 0;
        }

        for ($i = 1; $i <= strlen($code_string); $i++) {
            $code_length = $code_length + (int)(substr($code_string, ($i - 1), 1));
        }

        if (strtolower($orientation) == "horizontal") {
            $img_width = $code_length * $SizeFactor;
            $img_height = $size;
        } else {
            $img_width = $size;
            $img_height = $code_length * $SizeFactor;
        }

        $image = imagecreate($img_width, $img_height + $text_height);
        $black = imagecolorallocate($image, 0, 0, 0);
        $white = imagecolorallocate($image, 255, 255, 255);

        imagefill($image, 0, 0, $white);
        if ($print) {
            imagestring($image, 5, 31, $img_height, $text, $black);
        }

        $location = 10;
        for ($position = 1; $position <= strlen($code_string); $position++) {
            $cur_size = $location + (substr($code_string, ($position - 1), 1));
            if (strtolower($orientation) == "horizontal") {
                imagefilledrectangle($image, $location * $SizeFactor, 0, $cur_size * $SizeFactor, $img_height, ($position % 2 == 0 ? $white : $black));
            } else {
                imagefilledrectangle($image, 0, $location * $SizeFactor, $img_width, $cur_size * $SizeFactor, ($position % 2 == 0 ? $white : $black));
            }
            $location = $cur_size;
        }

        // Draw barcode to the screen or save in a file
        ob_start();
        imagepng($image);
        $image_data = ob_get_clean();
        imagedestroy($image);

        return response($image_data)->header('Content-Type', 'image/png');
    }

    public static function qr_code($arr)
    {
        $text = $arr['text'] ?? '';
        $size = $arr['size'] ?? 16.4;
        return QrCode::format("png")
        ->margin(1)
        ->size($size * 25)  // Multiply pixel size by 25 to adjust for QR code's native scaling.

        ->generate($text);
    }


    public static function generateQRCodeWithText()
    {
        $text = "Your QR Code Text Here";  // The text you want in the QR code
        $size = 200;  // Size of the QR code
        $fontSize = 5;  // Use GD's default font size (1 to 5)

        // Generate QR code as a base64 string
        $qrCode = QrCode::format('png')
                        ->size($size)
                        ->generate($text);

        // Create image from the generated QR code
        $image = imagecreatefromstring($qrCode);

        // Allocate colors
        $white = imagecolorallocate($image, 255, 255, 255);
        $black = imagecolorallocate($image, 0, 0, 0);

        // Get the width and height of the generated QR code image
        $imageWidth = imagesx($image);
        $imageHeight = imagesy($image);

        // Text to display at the bottom
        $textBelow = "Your Text Below";
        $textWidth = imagefontwidth($fontSize) * strlen($textBelow);  // Calculate the text width

        // Position the text in the center at the bottom of the image
        $textX = ($imageWidth - $textWidth) / 2;  // Horizontally center
        $textY = $imageHeight + 20;  // Position it below the QR code

        // Add text to the image
        imagestring($image, $fontSize, $textX, $textY, $textBelow, $black);

        // Output the image as a base64-encoded string
        ob_start();
        imagepng($image);
        $imageData = ob_get_contents();
        ob_end_clean();

        // Free up memory
        imagedestroy($image);

        // Convert the image data to base64
        $base64Image = base64_encode($imageData);

        // Return the base64 encoded image with the text below
        return 'data:image/png;base64,' . $base64Image;
    }



}
