<?php
namespace App\Http\Traits;

use App\Models\company;
use App\Models\role;
use App\Models\company_user;
use App\Models\supplier;

use App\Models\member;
use App\Models\notification;
use App\Models\system_setting;
use App\Models\system_notification;
use App\Models\user_company;
use Illuminate\Support\Facades\Mail;
use Swift_SmtpTransport;
use Swift_Mailer;
use Swift_Message;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

trait SystemMail
{
    public $mail_body = array();
    public $mail_subject;
    public $mail_link;
    public $mail_link2;// for mail
    public $mail_users2;
    public $flag;
    public $mail_content = array();
    public $mail_users = array();
    public $session_data = array();

    public function set_session($data)
    {
        $this->session_data = $data;
    }

    // public function send_mail($subject, $body, $link, $users, $flag="")
    // {
    //     if($flag == "otp")
    //     {
    //        $user=company::where('id',$users[0]['user_id'])->select('id','name','email')->first();
    //        $data = array('user'=>$user,'body'=>$body,'link'=>$link,"subject"=>$subject);
    //        $this->temp = $subject;
    //        $to_name = $user['name'];
    //        $to_email = $user['email'];
    //        $setting=system_setting::where('company_id','1')->first();
    //        $from_email = $setting->email ?? null;
    //        $from_password = $setting->password ?? null;
    //        $from_name = $setting->mail_from_name ?? null;
    //        $port=$setting->mail_port ?? null;
    //        $host=$setting->mail_host ?? null;

    //        $data=array('user'=>$this->recipient,'body'=>$body,"subject"=>$this->params['subject']);
    //        Mail::send('mails.'."custom_mail",$data,function($message) use ($to_name,$to_email, $from_email, $from_password,$from_name,$port,$host){
    //               $message->to($to_email)
    //               ->subject($this->params['subject'])
    //               ->from($from_email, $from_name);
    //               $transport = new Swift_SmtpTransport('smtp.googlemail.com', $port,'ssl');
    //               $transport->setUsername($from_email);
    //               $transport->setPassword($from_password);
    //               $transport->setStreamOptions([
    //                'ssl' => [
    //                    'verify_peer' => false,
    //                    'verify_peer_name' => false,
    //                    'allow_self_signed' => true
    //                ]]);

    //               // Create a new Swift Mailer instance using the SMTP transport
    //               $mailer = new Swift_Mailer($transport);

    //               // Set the Swift Mailer instance to the Mail facade
    //               Mail::setSwiftMailer($mailer);
    //        });
    //        if(count(Mail::failures()) > 0)
    //        {
    //           // die("failed");
    //        }
    //        else
    //        {

    //        }

    //     }
    //     else{
    //             $head_user = collect($users)->pluck('user_id')->toArray();
    //             $members = company_user::whereIn('id',$head_user)->select('id','name','email')->get();

    //             foreach($members as $user)
    //             {
    //                 $to_name = $user['name'];
    //                 $to_email = $user['email'];
    //                 $this->temp = $subject;
    //                 $data=array('user'=>$user,'body'=>$body,'link'=>$link,"subject"=>$subject);
    //                 $setting=system_setting::where('company_id','1')->first();
    //                 $from_email = $setting->email ?? null;
    //                 $from_password = $setting->password ?? null;
    //                 $from_name = $setting->mail_from_name ?? null;
    //                 $port=$setting->mail_port ?? null;
    //                 $host=$setting->mail_host ?? null;
    //                 Mail::send('mails.'."custom_mail",$data,function($message) use ($to_name,$to_email, $from_email, $from_password,$from_name,$port,$host,$subject){
    //                     $message->to($to_email)
    //                     ->subject($subject)
    //                     ->from($from_email, $from_name);
    //                     $transport = new Swift_SmtpTransport('smtp.googlemail.com', $port,'ssl');
    //                     $transport->setUsername($from_email);
    //                     $transport->setPassword($from_password);
    //                     $transport->setStreamOptions([
    //                      'ssl' => [
    //                          'verify_peer' => false,
    //                          'verify_peer_name' => false,
    //                          'allow_self_signed' => true
    //                      ]]);

    //                     // Create a new Swift Mailer instance using the SMTP transport
    //                     $mailer = new Swift_Mailer($transport);

    //                     // Set the Swift Mailer instance to the Mail facade
    //                     Mail::setSwiftMailer($mailer);
    //              });
    //                if(count(Mail::failures()) > 0)
    //                {
    //                   // die("failed");
    //                }
    //                else
    //                {

    //                }
    //             }
    //     }

    // }

    // public function send_mail_company_to_reseller($content, $params=[])
    // {
    //     $setting = system_setting::where('company_id',($params['company_id'] ?? 1))->first();
    //     $to_detail = system_setting::where('system_type',"reseller")->first();
    //     $to_name = $to_detail['mail_from_name'] ?? 'N/A';
    //     $to_email = $to_detail['email'];
    //     $from_email = $setting->email ?? null;
    //     $from_password = $setting->password ?? null;
    //     $from_name = $setting->mail_from_name ?? null;
    //     $port=$setting->mail_port ?? null;
    //     $host=$setting->mail_host ?? null;
    //     $footer=$setting->email_footer ?? null;
    //     $data=array('user'=>$to_detail, 'mail_content' => $content,'email_footer'=>$footer);
    //     Mail::send("mails.company_to_reseller",$data,function($message) use ($to_name,$to_email, $from_email, $from_password,$from_name,$port,$host,$content){
    //         $message->to($to_email)
    //         ->subject($content['subject'])
    //         ->from($from_email, $from_name);
    //         $transport = new Swift_SmtpTransport($host, $port,'ssl');
    //         $transport->setUsername($from_email);
    //         $transport->setPassword($from_password);
    //         $transport->setStreamOptions([
    //          'ssl' => [
    //              'verify_peer' => false,
    //              'verify_peer_name' => false,
    //              'allow_self_signed' => true
    //          ]]);

    //         // Create a new Swift Mailer instance using the SMTP transport
    //         $mailer = new Swift_Mailer($transport);

    //         // Set the Swift Mailer instance to the Mail facade
    //         Mail::setSwiftMailer($mailer);

    //  });

    // }

    public function send_to_members($users_arr,$params=[])
    {
        $counter = 0;
        $comp_id = null;
        // die($users);
        $session_data = $params['session_data'] ?? [];

        if(isset($params['company_id']) && isset($params['company_id'])!="")
        {
            $comp_id=$params['company_id'];
        }
        elseif(isset($session_data['fva_cmp_id']) && isset($session_data['fva_cmp_id'])!="")
        {
            $comp_id=$session_data['fva_cmp_id'];
        }
        elseif(isset($session_data['sup_comp_id']) && isset($session_data['sup_comp_id'])!="")
        {
            $comp_id = $session_data['sup_comp_id'];
        }
        else{
            $comp_id = null;
        }
        if( isset($param['type']) && $param['type'] == "reseller")
        {
            $setting = system_setting::where('system_type', "reseller")->first();
        }
        else
        {
            $setting = system_setting::where('company_id', $comp_id)->first();
        }
        foreach($users_arr as $u)
        {
            $arr = array('receiver_id'=>$u['user_id'],"type"=>'notification',
            "subject"=>$u['subject'],"short_description"=>$u['short_description'],
            'content'=>$u['content'],
            "link"=>$u['link'],
            "link2"=>$u['link2'],
            "company_id"=>($u['company_id'] ?? null),
            'created_at'=>date("Y-m-d H:i:s"),'updated_at'=>date("Y-m-d H:i:s"));
            if(notification::insert($arr))
            {
                $counter=$counter+1;
                $to_name = $u['name'];
                $to_email = $u['email'];
                $from_email = $setting->email ?? null;
                $from_password = $setting->password ?? null;
                $from_name = $setting->mail_from_name ?? null;
                $port=$setting->mail_port ?? null;
                $host=$setting->mail_host ?? null;
                $footer=$setting->email_footer ?? null;
                $data=array('user'=>$u, 'mail_content' => $arr,'email_footer'=>$footer);
                Mail::send('mails.'."custom_mail",$data,function($message) use ($to_name,$to_email, $from_email, $from_password,$from_name,$port,$host,$arr){
                $message->to($to_email)
                ->subject($arr['subject']);

         });


            }
        }
        return $counter;

    }
    public function get_users_by_permissions($mail_content,$permissions,$users_arr,$params=[])
    {

        $comp_id = null;
        // die($users);
        $session_data = $params['session_data'] ?? [];

        if(isset($params['company_id']) && isset($params['company_id'])!="")
        {
            $comp_id=$params['company_id'];
        }
        elseif(isset($session_data['fva_cmp_id']) && isset($session_data['fva_cmp_id'])!="")
        {
            $comp_id=$session_data['fva_cmp_id'];
        }
        else{
            $comp_id = null;
        }

        $users = company_user::whereHas("get_roles", function($q) use ($permissions,$comp_id)
        {
            $q->where("roles.company_id", $comp_id)->whereHas('get_permissions',function($q1) use ($permissions){
                 $q1->whereIn("code",$permissions);
            });
        })->get();


        foreach($users as $u)
        {
            $users_arr[] = array("user_id"=>$u->id,"email"=>$u->email,"name"=>$u->first_name." ".$u->last_name,"subject"=>$mail_content['subject'],"short_description"=>($mail_content['short_description'] ?? ''),
            "content"=>$mail_content['content'],"link"=>$mail_content['link'],
            "user_course_id" =>  null,
            "link2"=>$mail_content['link2'],"company_id"=>$comp_id
        );
        }
        return $users_arr;

    }



    public function get_mail_members($sub,$desc,$link,$roles,$exclude,$arr)
    {
        $users = company_user::whereHas("get_role", function($q) use ($roles)
        {
            $q->whereIn("role_code",$roles);
        })->whereNotIn("id",$exclude)->select("id","name","email")->get();

        foreach($users as $u)
        {
            $arr[] = array("user_id"=>$u->id,"email"=>$u->email,"name"=>$u->name,"subject"=>$sub,"description"=>$desc['description'],"link"=>$link,
            "link2"=>config("app.org_domain").$link
        );
        }
        return $arr;
    }

    // public function get_reseller_users($mail_content,$users_arr)
    // {
    //     $users = company_user::whereHas("get_roles", function($q)
    //     {
    //         $q->whereIn("role_code", [config("app.super_admin_role"), config("app.reseller_admin")]);
    //     })->get();

    //     foreach($users as $u)
    //     {
    //         $users_arr[] = array("user_id"=>$u->id,"email"=>$u->email,"name"=>$u->name,"subject"=>$mail_content['subject'],"short_description"=>($mail_content['short_description'] ?? ''),
    //         "content"=>$mail_content['content'],"link"=>$mail_content['link'],
    //         "user_course_id" =>  null,
    //         "link2" => $mail_content['link2']
    //     );
    //     }
    //     return $users_arr;
    // }
    // public function get_sub_company($mail_content,$users_arr,$params=[])
    // {
    //     $comp_id = $params['company_id'] ?? null;
    //     $uc = user_company::where("company_id",$params['company_id'] ?? null)->whereRelation("get_roles","role_code","=",config("app.admin_role"))
    //     ->with("get_company_user")->get();


    //     foreach($uc as $c)
    //     {
    //         $u = $c->get_company_user;
    //         $users_arr[] = array("user_id"=>$u->id,"email"=>$u->email,"name"=>$u->name,"subject"=>$mail_content['subject'],"short_description"=>($mail_content['short_description'] ?? ''),
    //         "content"=>$mail_content['content'],"link"=>$mail_content['link'],
    //         "user_course_id" =>  null,
    //         "link2" => $mail_content['link2'],"company_id"=>$comp_id
    //     );
    //     }
    //     return $users_arr;
    // }

    public function get_users_by_role($mail_content,$roles,$users_arr,$params=[])
    {

        $comp_id = null;
        // die($users);
        $session_data = $params['session_data'] ?? [];

        if(isset($params['company_id']) && isset($params['company_id'])!="")
        {
            $comp_id=$params['company_id'];
        }
        elseif(isset($session_data['fva_cmp_id']) && isset($session_data['fva_cmp_id'])!="")
        {
            $comp_id=$session_data['fva_cmp_id'];
        }
        else{
            $comp_id = null;
        }
        // $users = company_user::whereHas("get_roles", function($q) use ($roles)
        // {
        //     $q->whereIn("role_code",$roles);
        // })->select("id","name","email","company_id")
        // ->whereRelation("get_main_company","companies.id","=",$params['company_id'] ?? 1)->get();
        $user_company = user_company::where("company_id", $comp_id)->
        whereHas("get_roles", function($q) use ($roles)
        {
            $q->whereIn("role_code",$roles);
        })->get();

        foreach($user_company as $uc)
        {
            $u = $uc->get_company_user;
            $users_arr[] = array("user_id"=>$u->id,"email"=>$u->email,"name"=>$u->first_name,"subject"=>$mail_content['subject'],"short_description"=>($mail_content['short_description'] ?? ''),
            "content"=>$mail_content['content'],"link"=>$mail_content['link'],
            "user_course_id" =>  null,
            "link2"=>$mail_content['link2'],"company_id"=>$comp_id
        );
        }
        return $users_arr;

    }
    public function get_users_by_id($mail_content,$ids,$users_arr,$params=[])
    {
        $comp_id = null;
        // die($users);
        $session_data = $params['session_data'] ?? [];

        if(isset($params['company_id']) && isset($params['company_id'])!="")
        {
            $comp_id=$params['company_id'];
        }
        elseif(isset($session_data['fva_cmp_id']) && isset($session_data['fva_cmp_id'])!="")
        {
            $comp_id=$session_data['fva_cmp_id'];
        }
        else{
            $comp_id = null;
        }

        $users = company_user::whereIn("id",$ids)->select("first_name","id","email","password")->get();
        foreach($users as $u)
        {
            $users_arr[] = array("user_id"=>$u->id,"email"=>$u->email,"name"=>$u->first_name,"subject"=>$mail_content['subject'],"short_description"=>$mail_content['short_description'],
            "content"=>$mail_content['content'],"link"=>$mail_content['link'],
            "link2"=>$mail_content['link2'],"company_id"=> $comp_id
        );
        }
        return $users_arr;
    }
    public function get_suppliers_by_id($mail_content,$ids,$supplier_arr,$params=[])
    {
        $comp_id = null;
        // die($users);
        $session_data = $params['session_data'] ?? [];

        if(isset($params['company_id']) && isset($params['company_id'])!="")
        {
            $comp_id=$params['company_id'];
        }
        elseif(isset($session_data['sup_company_id']) && isset($session_data['sup_company_id'])!="")
        {
            $comp_id=$session_data['sup_company_id'];
        }
        else{
            $comp_id = null;
        }

        $suppliers = supplier::whereIn("id",$ids)->select("first_name","id","email","password")->get();
        foreach($suppliers as $u)
        {
            $supplier_arr[] = array("user_id"=>$u->id,"email"=>$u->email,"name"=>$u->first_name,"subject"=>$mail_content['subject'],"short_description"=>$mail_content['short_description'],
            "content"=>$mail_content['content'],"link"=>$mail_content['link'],
            "link2"=>$mail_content['link2'],"company_id"=> $comp_id
        );
        }
        return $supplier_arr;
    }
    public function send_to_suppliers($users_arr, $params = [])
{
    $counter = 0;
    $comp_id = null;
    $supplier_id = null;
    $session_data = $params['session_data'] ?? [];

    // Determine company ID
    if (!empty($params['company_id'])) {
        $comp_id = $params['company_id'];
    } elseif (!empty($session_data['fva_cmp_id'])) {
        $comp_id = $session_data['fva_cmp_id'];
    } elseif (session()->has('sup_company_id')) {
        $comp_id = session('sup_company_id');
    }

    // Determine type and get system settings
    $type = $params['type'] ?? null;
    if ($type === 'reseller') {
        $setting = system_setting::where('system_type', 'reseller')->first();
    } else {
        $setting = system_setting::where('company_id', $comp_id)->first();
    }

    foreach ($users_arr as $u) {
        $arr = [
            'supplier_id'        => $u['user_id'],
            'type'               => 'notification',
            'subject'            => $u['subject'],
            'short_description'  => $u['short_description'],
            'content'            => $u['content'],
            'link'               => $u['link'],
            'link2'              => $u['link2'],
            'company_id'         => $u['company_id'] ?? $comp_id,
            'supplier_id'        => $u['supplier_id'] ?? $supplier_id,
            'created_at'         => now(),
            'updated_at'         => now()
        ];

        if (notification::insert($arr)) {
            $counter++;

            $to_name = $u['name'];
            $to_email = $u['email'];
            $from_email = $setting->email ?? null;
            $from_password = $setting->password ?? null;
            $from_name = $setting->mail_from_name ?? null;
            $port = $setting->mail_port ?? null;
            $host = $setting->mail_host ?? null;
            $footer = $setting->email_footer ?? null;

            $data = [
                'user'         => $u,
                'mail_content' => $arr,
                'email_footer' => $footer
            ];

            Mail::send('mails.custom_mail', $data, function ($message) use ($to_name, $to_email, $from_email, $from_name, $arr) {
                $message->to($to_email)
                        ->subject($arr['subject']);
            });
        }
    }

    return $counter;
}

    public function roleHasPermission($roleCode, $permission)
    {
              $GLOBALS['permission']=$permission;
              $per=role::where('role_code',$roleCode)->withCount(['get_permissions'=>function($q){
                $q->where('code',$GLOBALS['permission']);
              }])->first();
            //dd($per);
              if($per->get_permissions_count>0)
              {
               return true;
              }
              else{
                return false;
              }
    }
    public function check_notification($noti)
    {
        $notification=system_notification::where('name',$noti)->with('get_status',function($q){
            $q->where('status','true');
        })->with('get_roles_recipients','get_include_recipients','get_exclude_recipients')->first();
        if($notification)
        {
            return $notification;
        }
        else{
            return false;
        }
    }
    public function get_users_by_notification($mail_content, $users_arr, $notification, $params = [])
    {
        $comp_id = $params['company_id'] ?? ($params['session_data']['fva_cmp_id'] ?? ($params['session_data']['supp_comp_id'] ?? null));
        if (!$comp_id) {
            throw new \Exception('Company ID is required');
        }
        $roles = role::whereHas('notification_recipients', function ($q) use ($notification) {
            $q->where('system_notification_id', $notification->id);
        })
        ->where('company_id', $comp_id)
        ->pluck('id');

        // Get excluded users for the notification
        $exc_users = company_user::whereHas('notification_recipients', function ($q) use ($notification) {
            $q->where('system_notification_id', $notification->id)
              ->where('type', 'exclude');
        })
        ->pluck('id');
        $users = company_user::whereHas('get_roles', function ($q) use ($roles, $comp_id) {
            $q->whereIn('roles.id', $roles)
              ->where('roles.company_id', $comp_id);
        })
        ->orWhereHas('notification_recipients', function ($q) use ($notification,$comp_id) {
            $q->where('system_notification_id', $notification->id)
              ->where('type', 'include')->where('company_id', $comp_id);
        })
        ->whereNotIn('id', $exc_users)
        ->select('id', 'first_name', 'email')
        ->get();

        // Prepare the users array
        foreach ($users as $u) {
            $users_arr[] = [
                'user_id' => $u->id,
                'email' => $u->email,
                'name' => $u->first_name,
                'subject' => $mail_content['subject'],
                'short_description' => $mail_content['short_description'] ?? '',
                'content' => $mail_content['content'],
                'link' => $mail_content['link'],
                'user_course_id' => null,
                'link2' => $mail_content['link2'],
                'company_id' => $comp_id,
            ];
        }

        return $users_arr;
    }

    // public function send_to_company($params=[])
    // {
    //     $to_name = "N/A";
    //     $to_email = "N/A";
    //     if(isset($params['company_id']))
    //     {
    //         $to_detail = company::where('id',($params['company_id'] ?? null))->first();
    //         $setting = system_setting::where('company_id',($params['company_id'] ?? null))->first();
    //         $to_name = $to_detail['name'] ?? 'N/A';
    //         $to_email = $to_detail['email'];
    //     }
    //     else
    //     {
    //         $setting = system_setting::where('system_type',"reseller")->first();
    //         $to_name = $setting['to_name'] ?? 'N/A';
    //         $to_email = $setting['to_email'];
    //         $to_detail = array("name"=>$to_name,"email"=>$to_email);
    //     }
    //     $file = $params['file'] ?? null;
    //     $from_email = $setting->email ?? null;
    //     $from_password = $setting->password ?? null;
    //     $from_name = $setting->mail_from_name ?? null;
    //     $port = $setting->mail_port ?? null;
    //     $host = $setting->mail_host ?? null;
    //     $footer = $setting->email_footer ?? null;
    //     $content = $params['content'] ?? 'N/A';
    //     $req = $content['req'];
    //     $attachment = $content['attachment'];
    //     // die(json_encode($content) );
    //     $data=array('user'=>$to_detail, 'mail_content' => $content,'email_footer'=>$footer);
    //     Mail::send("mails.company_to_reseller",$data,function($message) use ($to_name,$to_email, $from_email, $from_password,$from_name,$port,$host,$content,$req,$attachment){
    //         $message->to($to_email)
    //         ->subject($content['subject'])
    //         ->from($from_email, $from_name);
    //         if (isset($attachment['content']))
    //         {
    //             $message->attachData($attachment['content'], $attachment['name'], ['mime' => mime_content_type($attachment['path'])]);
    //         }
    //         $transport = new Swift_SmtpTransport($host, $port,'ssl');
    //         $transport->setUsername($from_email);
    //         $transport->setPassword($from_password);
    //         $transport->setStreamOptions([
    //          'ssl' => [
    //              'verify_peer' => false,
    //              'verify_peer_name' => false,
    //              'allow_self_signed' => true
    //          ]]);

    //         // Create a new Swift Mailer instance using the SMTP transport
    //         $mailer = new Swift_Mailer($transport);

    //         // Set the Swift Mailer instance to the Mail facade
    //         Mail::setSwiftMailer($mailer);

    //  });
    // }
}


?>
