import axios from 'axios';

export const checkAuth = async () => {
  try {
    const response = await axios.get('/api/check-session');
    if (response.data.otp_pending) {
      return {
        authenticated: false,
        otp_pending: true,
        user: null
      };
    }

    return {
      authenticated: response.data.authenticated,
      user: response.data.user,
      userType: response.data.type
    };
  } catch (error) {
    if (error.response?.status === 403 && error.response?.data?.blocked) {
      return {
        authenticated: false,
        blocked: true,
        user: null
      };
    }

    return {
      authenticated: false,
      user: null
    };
  }
};
