import { createRouter, createWebHistory } from "vue-router";
import routes from "./routes";

const router = createRouter({
  history: createWebHistory(),
  routes,
});
router.beforeEach((to, from, next) => {
  const user = localStorage.getItem("user");
  if (to.meta.requiresAuth && !user) {
    next({ path: "/admin-login" });
  } else if (to.path === "/admin-login" && user) {
    next({ path: "/" });
  } else {
    next();
  }
});

export default router;
