import { createRouter, createWebHistory } from 'vue-router';
import AdminLayout from './pages/layouts/adminlayout.vue'
import PublicLayout from './pages/layouts/layout.vue';

// Admin pages
import Dashboard from './pages/Dashboard.vue';
import DepartmentCreate from './pages/Departments/create.vue';
import DepartmentManage from './pages/Departments/manage.vue';
import EditDepartment from './pages/Departments/edit.vue';
import EmployeeCreate from './pages/employees/create.vue';
import EmployeeManage from './pages/employees/manage.vue';
import EmployeeEdit from './pages/employees/edit.vue';
import CustomFieldCreate from './pages/custom_fields/create.vue';
import CustomFieldManage from './pages/custom_fields/manage.vue';
import CustomFieldEdit from './pages/custom_fields/edit.vue';

// Public pages
import Onboarding from './pages/frontend/home.vue';

const routes = [
  {
    path: '/',
    component: PublicLayout,
    children: [
      { path: '', name: 'onboarding', component: Onboarding },
    ],
  },
  {
    path: '/',
    component: AdminLayout,
    children: [
      { path: 'dashboard', name: 'dashboard', component: Dashboard },
      { path: 'departments/create', name: 'department.create', component: DepartmentCreate },
      { path: 'departments/manage', name: 'department.manage', component: DepartmentManage },
      { path: 'departments/edit/:id', name: 'department.edit', component: EditDepartment },
      { path: 'employees/create', name: 'employee.create', component: EmployeeCreate },
      { path: 'employees/manage', name: 'employee.manage', component: EmployeeManage },
      { path: 'employees/edit/:id', name: 'employee.edit', component: EmployeeEdit, props: true },
      { path: 'custom-fields/create', name: 'custom_fields.create', component: CustomFieldCreate },
      { path: 'custom-fields/manage', name: 'custom_fields.manage', component: CustomFieldManage },
      { path: 'custom-fields/edit/:id', name: 'custom_fields.edit', component: CustomFieldEdit, props: true },
    ],
  },
];

const router = createRouter({
  history: createWebHistory(),
  routes,
});

export default router;
