import { createApp } from 'vue';
import { createRouter, createWebHistory } from 'vue-router';
import AdminLogin from './pages/auth/AdminLogin.vue';
import Dashboard from './pages/Dashboard.vue';
const routes = [
    { path: '/', name: 'login', component: AdminLogin }, // login page
    { path: '/dashboard', name: 'dashboard', component: Dashboard }, // dashboard
];
const router = createRouter({
    history: createWebHistory(), // uses HTML5 history mode
    routes,
});
const app = createApp(AdminLogin); // root component can be AdminLogin
app.use(router); // install router
app.mount('#login-app'); // mount on the Blade div
