import './bootstrap';
import { createApp } from 'vue';
import { createRouter, createWebHistory } from 'vue-router';
import App from './App.vue';
import PlainLayout from './pages/layouts/layout.vue'
import LandingForm from './pages/frontend/home.vue'

import Dashboard from './pages/Dashboard.vue';
import DepartmentCreate from './pages/Departments/create.vue';
import EditDepartment from './pages/Departments/edit.vue';
import DepartmentManage from './pages/Departments/manage.vue';
import EmployeeCreate from './pages/employees/create.vue';
import EmployeeManage from './pages/employees/manage.vue';
import '@fortawesome/fontawesome-free/css/all.min.css';
import EmployeeEdit from './pages/employees/edit.vue';
import CustomFieldCreate from './pages/custom_fields/create.vue';
import CustomFieldManage from './pages/custom_fields/manage.vue';
import CustomFieldEdit from './pages/custom_fields/edit.vue';
import MyVisits from './pages/employees/my-visits.vue';
import AdminLogin from './pages/auth/AdminLogin.vue';
import VisitProfile from './pages/visits/visit-profile.vue';
import { checkAuth } from './utils/auth';
import managePlaces from './pages/dropdown_options/managePlaces.vue';
import manageReasons from './pages/dropdown_options/manageReasons.vue';
import manageTypes from './pages/dropdown_options/manageTypes.vue';
import AllVisits from './pages/visits/all-visits.vue';
import activityLogs from './pages/visits/activity-logs.vue';
import myProfile from './pages/employees/my-profile.vue';
import AddCompany from "./pages/companies/company-add.vue";
import ManageCompany from "./pages/companies/company-manage.vue";
import EditCompany from "./pages/companies/company-edit.vue";
import Companies from "./components/companies.vue";
import ManageInstructions from "./pages/instructions/manage.vue";
import ImportCustomField from "./pages/custom_fields/import.vue";
const routes = [
  { path: '/', redirect: '/dashboard' },
  { path: '/dashboard', name: 'dashboard', component: Dashboard },
   { path: '/departments/create', name: 'department.create', component: DepartmentCreate },
  { path: '/departments/manage', name: 'department.manage', component: DepartmentManage },
    { path: '/employees/create', name: 'employee.create', component: EmployeeCreate },
  { path: '/employees/manage', name: 'employee.manage', component: EmployeeManage },
    { path: '/employees/edit/:id', name: 'employee.edit', component: EmployeeEdit, props: true },
    { path: '/departments/edit/:id', name: 'department.edit', component: EditDepartment },
      { path: '/instructions/manage', name: 'instructions.manage', component: ManageInstructions },
    {
    path: '/custom-fields/create/:groupId?',
    name: 'custom_fields.create',
    component: CustomFieldCreate,
    },
  { path: '/custom-fields/manage', name: 'custom_fields.manage', component: CustomFieldManage },
  { path: '/custom-fields/edit/:id', name: 'custom_fields.edit', component: CustomFieldEdit, props: true },
  { path: '/places/manage', name: 'places.manage', component: managePlaces },
   { path: '/visit-types/manage', name: 'visit-types.manage', component: manageTypes },
   { path: '/visit-reasons/manage', name: 'visit-reasons.manage', component: manageReasons },
    {
    path: '/my-visits',
    name: 'MyVisits',
    component: MyVisits,
    meta: { title: 'My Visits' }
  },
  {
    path: '/allVisits',
    name: 'allVisits',
    component: AllVisits,
    meta: { title: 'All Visits' }
  },
  {
      path: '/activity-logs',
      name: 'activity-logs',
    component: activityLogs,
  },
 {
    path: '/home',
    component: PlainLayout,
    children: [
      {
        path: '',
        name: 'landing',
        component: LandingForm,
      },

    ],
  },
    {
    path: '/visit-profile/:id',
    name: 'visit-profile',
    component: VisitProfile,
    meta: { requiresAuth: true },
  },
    {
    path: '/custom-field-groups',
    name: 'custom-field-groups',
    component: () => import('@/pages/custom_fields/groups.vue'),
    meta: { requiresAuth: true },
    },
    {path: '/custom-field-imports', name: 'custom-field-imports', component: ImportCustomField},
{ path: '/my/profile', name: 'my/profile', component: myProfile },
  {
    path: "/company/create",
    name: "AddCompany",
    component: AddCompany,
  },
   {
    path: "/company/manage",
    name: "ManageCompany",
    component: ManageCompany,
  },
    {path: "/company/edit/:external_id", name: "company.edit",component: EditCompany, props: true, },
    {
  path: '/companies',
  name: 'Companies',
  component: Companies,
  meta: { requiresAuth: true },
}

];

const router = createRouter({
  history: createWebHistory(),
  routes,
});
router.beforeEach(async (to, from, next) => {
  const publicRoutes = ['login', 'OtpVerification'];

  if (publicRoutes.includes(to.name)) {
    return next();
  }

  const auth = await checkAuth();
  if (!auth.authenticated) {
    return window.location.href = '/auth/admin-login';
  }

  const user = auth.user;

  if (user.block_status === 'true') {
    alert('Your account is blocked.');
    return window.location.href = '/auth/admin-login';
  }

  if (to.meta.requiresReseller && user.type !== 'reseller') {
    return next({ name: 'dashboard' });
  }

  if (to.meta.requiresSuperAdmin && user.type !== 'super_admin') {
    alert('Access denied: Super Admin only.');
    return next({ name: 'dashboard' });
  }

  next();
});



export default router;


createApp(App)
  .use(router)
  .mount('#app');
