<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\dropdown_option;

class DropdownOptionsSeeder extends Seeder
{
    public function run($company_id = null)
    {
        $visitReasons = [
            'Meeting with staff or management',
            'Conducting internal audit or compliance review',
            'Product demonstration or business discussion',
            'Performing external compliance inspection',
            'Performing maintenance or installation work',
            'General visit or miscellaneous purpose'
        ];

        $visitTypes = [
            'Visitor',
            'Auditor',
            'Customer',
            'Regulatory Auditor',
            'Contractor',
            'Other'
        ];

        foreach ($visitReasons as $reason) {
    $option = new dropdown_option();
    $option->company_id = $company_id;
    $option->type = 'visit_reason';
    $option->value = $reason;
    $option->save();
}

// Insert Visitor Types
foreach ($visitTypes as $type) {
    $option = new dropdown_option();
    $option->company_id = $company_id;
    $option->type = 'visit_type';
    $option->value = $type;
    $option->save();
}
    }
}
