<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
     public function up(): void
    {
        Schema::table('custom_fields', function (Blueprint $table) {
            $table->unsignedBigInteger('parent_id')->nullable()->after('id');
            $table->string('type')->nullable()->after('parent_id');
            $table->enum('display_on', ['yes', 'no', 'always'])->default('always')->after('type');
             $table->string('field_type')->nullable()->change();
        });
    }
    public function down(): void
    {
        Schema::table('custom_fields', function (Blueprint $table) {
            $table->dropColumn(['parent_id', 'type', 'display_on']);
        });
    }
};
