<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('visit_host_responses', function (Blueprint $table) {
            // Drop the existing foreign key constraint
            $table->dropForeign(['place_id']);

            // Add new foreign key to dropdown_options(id)
            $table->foreign('place_id')
                ->references('id')
                ->on('dropdown_options')
                ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::table('visit_host_responses', function (Blueprint $table) {
            // Rollback to reference places(id)
            $table->dropForeign(['place_id']);

            $table->foreign('place_id')
                ->references('id')
                ->on('places')
                ->onDelete('cascade');
        });
    }
};
