<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('activity_logs', function (Blueprint $table) {
            $table->id();
            $table->string('type');
            $table->string('action'); 
            $table->text('message'); 
            $table->string('ip_address')->nullable();
            $table->string('browser')->nullable();
            $table->BigInteger('company_user_id')->unsigned()->nullable();
            $table->foreign('company_user_id')->references('id')->on('company_users')->onDelete('set null');  
            $table->BigInteger('visitor_id')->unsigned()->nullable();
            $table->foreign('visitor_id')->references('id')->on('visitors')->onDelete('set null');  
            $table->BigInteger('company_id')->unsigned()->nullable();
            $table->foreign('company_id')->references('id')->on('companies')->onDelete('cascade');  
          
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('activity_logs');
    }
};
