<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('visitor_custom_field_values', function (Blueprint $table) {
             $table->unsignedBigInteger('visit_id')->nullable()->after('id');
            $table->foreign('visit_id')
                  ->references('id')
                  ->on('visits')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('visitor_custom_field_values', function (Blueprint $table) {
              $table->dropForeign(['visit_id']);

            // Then drop the column
            $table->dropColumn('visit_id');
        });
    }
};
