<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('company_users', function (Blueprint $table) {
            $table->string('otp', 10)->nullable()->after('password');
            $table->dateTime('otp_expire')->nullable()->after('otp');
            $table->enum('block_status', ['true', 'false'])->default('false')->after('otp_expire');
        });
    }

    public function down(): void
    {
        Schema::table('company_users', function (Blueprint $table) {
            $table->dropColumn(['otp', 'otp_expire', 'block_status']);
        });
    }
};
