<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_profiles', function (Blueprint $table) {
            $table->id();

            // Optional foreign key to users table (if needed)
            $table->unsignedBigInteger('user_id')->nullable()->index();

            $table->string('photo_path')->nullable(); // Path to stored photo
            $table->longText('fingerprint_data')->nullable(); // Fingerprint template data
            $table->string('address')->nullable();
            $table->longText('face_id_data')->nullable(); // Face recognition data
            $table->string('organization')->nullable();
            $table->boolean('blacklisted')->default(false); // Whether user is blacklisted

            $table->timestamps();

            // Optional: set up foreign key constraint if linked to users
            $table->foreign('user_id')
                  ->references('id')
                  ->on('users')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_profiles');
    }
};
