<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('company_users', function (Blueprint $table) {
            // Add new columns
            if (!Schema::hasColumn('company_user', 'first_name')) {
                $table->string('first_name')->after('id')->nullable();
            }

            if (!Schema::hasColumn('company_user', 'last_name')) {
                $table->string('last_name')->after('first_name')->nullable();
            }

            // Drop old "name" column if it exists
            if (Schema::hasColumn('company_user', 'name')) {
                $table->dropColumn('name');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('company_user', function (Blueprint $table) {
            // Recreate "name" column
            if (!Schema::hasColumn('company_user', 'name')) {
                $table->string('name')->after('id')->nullable();
            }

            // Drop new columns
            if (Schema::hasColumn('company_user', 'first_name')) {
                $table->dropColumn('first_name');
            }

            if (Schema::hasColumn('company_user', 'last_name')) {
                $table->dropColumn('last_name');
            }
        });
    }
};
