<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('notifications', function (Blueprint $table) {
            $table->id(); // Primary Key
            $table->string('external_id')->nullable()->unique();
            $table->unsignedBigInteger('company_id');
            $table->string('type')->nullable();
            $table->unsignedBigInteger('recipient_id')->nullable();
            $table->string('recipient_type')->nullable();
            $table->text('message')->nullable();
            $table->string('trigger_event')->nullable(); // e.g. visit_approved, visitor_checked_in
            $table->enum('status', ['pending', 'sent', 'failed'])->default('pending');
            $table->timestamp('sent_at')->nullable();
            $table->timestamps();

            // Foreign key constraint for company
            $table->foreign('company_id')
                  ->references('id')
                  ->on('companies')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('notifications');
    }
};
