<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\activity_log;
class ActivityController extends Controller
{
  public function index(Request $request)
{
    $companyId = $request->company_id ?? session('company_id');

    $perPage = $request->query('per_page', config('app.pagination', 10));
    $page = $request->query('page', 1);

    $query = activity_log::with(['get_visit.get_visitor'])
        ->where('company_id', $companyId)
        ->orderBy('id', 'desc');

    $logs = $query->paginate($perPage, ['*'], 'page', $page);

    return response()->json([
        'logs' => $logs->items(),
        'pagination' => [
            'current_page' => $logs->currentPage(),
            'last_page' => $logs->lastPage(),
            'per_page' => $logs->perPage(),
            'total' => $logs->total(),
        ],
    ]);
}

}
