<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\company_user;

class UserAuth
{
    public function handle(Request $request, Closure $next)
    {
        if (!$request->session()->has('comp_user_id')) {
            if ($request->expectsJson()) {
                return response()->json([
                    'status' => false,
                    'message' => 'Unauthorized access. Please log in.'
                ], 401);
            }

            return redirect()->route('login'); // keep route name simple
        }

        $user = company_user::find($request->session()->get('comp_user_id')); // ✅ fix typo: NOT coompany_user
        if ($user && $user->block_status === 'true') {
            $request->session()->flush();
            if ($request->expectsJson()) {
                return response()->json([
                    'status' => false,
                    'message' => 'Your account is blocked.'
                ], 403);
            }

            return redirect()->route('login')->with('error', 'Your account is blocked.');
        }

        return $next($request);
    }
}
