<?php

namespace App\Imports;

use App\Models\custom_field;
use App\Models\custom_field_group;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Illuminate\Support\Str;

class CustomFieldsImport implements ToModel, WithHeadingRow
{
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {
        $groupId =custom_field_group::where('external_id', $row['group_id'])->value('id');

        if (!$groupId) {
            return null; // skip row if group not found
        }
        $name = Str::slug($row['label'], '-');

        return new custom_field([
            'group_id'   => $groupId,
            'label'      => $row['label'],
            'name'       => $name,
            'type'       => strtolower($row['type'] ?? 'text'),
            'is_required'=> (int)($row['is_required'] ?? 0),
            'external_id'=> \App\Http\Classes\Generic::generate_id('custom-field'),
        ]);
    }
}
