<?php
namespace App\Http\Traits;

use App\Models\company;
use App\Models\company_user;
use App\Models\visitor;
use App\Models\notification;
use App\Models\system_setting;
use App\Models\system_notification;
use Illuminate\Support\Facades\Mail;
use Swift_SmtpTransport;
use Swift_Mailer;
use Swift_Message;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

trait SystemMail
{
    public $mail_body = array();
    public $mail_subject;
    public $mail_link;
    public $mail_link2;// for mail
    public $mail_users2;
    public $flag;
    public $mail_content = array();
    public $mail_users = array();
    public $session_data = array();

    public function set_session($data)
    {
        $this->session_data = $data;
    }

   public function send_to_members($users_arr,$params=[])
    {
        $counter = 0;
        $comp_id = null;
        // die($users);
        $session_data = $params['session_data'] ?? [];

        if(isset($params['company_id']) && isset($params['company_id'])!="")
        {
            $comp_id=$params['company_id'];
        }
        else{
            $comp_id = null;
        }
       if( isset($params['type']) && $params['type'] == "reseller")
        {

            $setting = system_setting::where('system_type', "reseller")->first();
        }
        elseif($comp_id!="")
        {
            $setting = system_setting::where('company_id', $comp_id)->first();
            if(!$setting)
            {
                 $setting = system_setting::where('system_type', "reseller")->first();
            }
        }
        else{
           $setting = system_setting::where('system_type', "reseller")->first();

        }



        foreach($users_arr as $u)
        {
            $arr = array('receiver_id'=>$u['user_id'],"type"=>'notification',
            "subject"=>$u['subject'],"short_description"=>$u['short_description'],
            'content'=>$u['content'],
            "link"=>$u['link'],
            "link2"=>$u['link2'],
           "company_id" => ($u['company_id'] ?? $comp_id ?? session('company_id') ?? 1),
            'created_at'=>date("Y-m-d H:i:s"),'updated_at'=>date("Y-m-d H:i:s"));
          if(notification::insert($arr))
            {
                $counter=$counter+1;
                $from_email = (string) ($setting->email ?? env('MAIL_USERNAME', 'solutions@qexcel.ca'));
                $from_password = (string) ($setting->password ?? env('MAIL_PASSWORD', '5?2d.HhIAur;'));
                $from_name = (string) ($setting->mail_from_name ?? env('MAIL_FROM_NAME', 'Qexcel'));
                $port = (int) ($setting->mail_port ?? env('MAIL_PORT', 465));
                $host = (string) ($setting->mail_host ?? env('MAIL_HOST', 'mail.qexcel.ca'));

                $to_email = (string) ($u['email'] ?? '');
                $to_name = (string) ($u['name'] ?? 'Backup User');

                    $footer = $setting->email_footer ?? null;

                    $data = ['user' => $u, 'mail_content' => $arr, 'email_footer' => $footer];
                  $smtpDetails = [
                        'mail.mailer' => 'smtp',
                        'mail.mailers.smtp.host' => $host,
                        'mail.mailers.smtp.port' => $port,
                        'mail.mailers.smtp.username' => $from_email,
                        'mail.mailers.smtp.password' => $from_password, // log with caution
                        'mail.mailers.smtp.encryption' => 'ssl',
                    ];

                    config($smtpDetails);

                    Log::info('SMTP Details:', $smtpDetails);

                    Mail::send('mails.custom_mail', $data, function ($message) use (
                        $to_name,
                        $to_email,
                        $from_email,
                        $from_name,
                        $arr
                    ) {
                        $message->to($to_email)
                            ->subject($arr['subject'])
                            ->from($from_email, $from_name);
                    });

            }
                }
                return $counter;

    }
    public function get_users_by_id($mail_content,$ids,$users_arr,$params=[])
    {
        $comp_id = null;
        // die($users);
        $session_data = $params['session_data'] ?? [];

        if(isset($params['company_id']) && isset($params['company_id'])!="")
        {
            $comp_id=$params['company_id'];
        }
        else{
            $comp_id = null;
        }

        $users = company_user::whereIn("id",$ids)->select("first_name","id","email","password")->get();
        foreach($users as $u)
        {
            $users_arr[] = array("user_id"=>$u->id,"email"=>$u->email,"name"=>$u->first_name,"subject"=>$mail_content['subject'],"short_description"=>$mail_content['short_description'],
            "content"=>$mail_content['content'],"link"=>$mail_content['link'],
            "link2"=>$mail_content['link2'],"company_id"=> $comp_id
        );
        }
        return $users_arr;
    }
  public function get_visitors_by_id($mail_content, $ids, $visitor_arr, $params = [])
    {
        $comp_id = null;
        $session_data = $params['session_data'] ?? [];
        if (!empty($params['company_id'])) {
            $comp_id = $params['company_id'];
        } elseif (!empty($session_data['visitor_company_id'])) {
            $comp_id = $session_data['visitor_company_id'];
        } elseif (session()->has('visitor_company_id')) {
            $comp_id = session('visitor_company_id');
        }

        $visitors = visitor::whereIn("id", $ids)
            ->select("first_name", "id", "email")
            ->get();

        foreach ($visitors as $v) {
            $visitor_arr[] = [
                "user_id"           => $v->id,
                "email"             => $v->email,
                "name"              => $v->first_name,
                "subject"           => $mail_content['subject'],
                "short_description" => $mail_content['short_description'],
                "content"           => $mail_content['content'],
                "link"              => $mail_content['link'],
                "link2"             => $mail_content['link2'],
                "company_id"        => $comp_id
            ];
        }

        return $visitor_arr;
    }
    public function send_to_visitors($visitors_arr, $params = [])
    {
        $counter = 0;
        $comp_id = null;
        $session_data = $params['session_data'] ?? [];
        if (!empty($params['company_id'])) {
            $comp_id = $params['company_id'];
        } elseif (!empty($session_data['visitor_company_id'])) {
            $comp_id = $session_data['visitor_company_id'];
        } elseif (session()->has('visitor_company_id')) {
            $comp_id = session('visitor_company_id');
        }
        $setting = system_setting::where('company_id', $comp_id)->first();

        foreach ($visitors_arr as $v) {
            $notificationData = [
                'visitor_id'       => $v['user_id'],
                'type'             => 'notification',
                'subject'          => $v['subject'],
                'short_description'=> $v['short_description'],
                'content'          => $v['content'],
                'link'             => $v['link'],
                'link2'            => $v['link2'],
                'company_id'       => $v['company_id'] ?? $comp_id ?? 1,
                'created_at'       => now(),
                'updated_at'       => now()
            ];

            if (notification::insert($notificationData)) {
                $counter++;

                $to_name = $v['name'];
                $to_email = $v['email'];

                $from_email = $setting->email ?? config('mail.from.address');
                $from_name = $setting->mail_from_name ?? config('mail.from.name');
                $footer = $setting->email_footer ?? '';
                   if (empty($notificationData['link']) && empty($notificationData['link2'])) {
                                unset($notificationData['link'], $notificationData['link2']);
                            }

                    $data = [
                        'user'         => $v,
                        'mail_content' => $notificationData,
                        'email_footer' => $footer
                    ];

                Mail::send('mails.custom_mail', $data, function ($message) use ($to_name, $to_email, $from_email, $from_name, $notificationData) {
                    $message->to($to_email, $to_name)
                            ->from($from_email, $from_name)
                            ->subject($notificationData['subject']);
                });
            }
        }

        return $counter;
    }


}


?>
