<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use App\Models\department;
use App\Models\company;
use App\Models\place;
use App\Http\Classes\Generic;
class DepartmentController extends Controller
{
   public function add(Request $req)
{
    if ($req->isMethod('post')) {
        $validator = Validator::make($req->all(), [
            'name' => 'required|string|max:255',
            'description' => 'nullable|string|max:500',
            'status' => 'required|in:active,inactive',
        ]);

        if ($validator->fails()) {
            if ($req->ajax()) {
                return response()->json(['errors' => $validator->errors()], 422);
            }
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $department = new department();
        $department->external_id = Generic::generate_id('dept');
        $department->company_id = session('company_id');
        $department->name = $req->name;
        $department->description = $req->description ?? '';
        $department->status = $req->status;
        $department->save();

        if ($req->ajax()) {
            return response()->json(['message' => 'Department created successfully!']);
        }

        return redirect()->back()->with('success', 'Department created successfully!');
    }

    return view('admin.departments.create');
}
public function list(Request $request)
{
    $search = $request->query('search');
    $externalId = $request->query('external_id');
    $paginate = $request->query('paginate', false);
    $companyId = session('company_id');

    $perPage = config('app.pagination', 10);

    if (!$companyId && $externalId) {
        $company = company::where('external_id', $externalId)->first();
        if ($company) {
            $companyId = $company->id;
        }
    }

    if (!$companyId) {
        return response()->json([
            'message' => 'Company not found.',
            'departments' => [],
        ], 404);
    }

    $query = department::where('company_id', $companyId)
        ->orderBy('id', 'desc');

    if (!empty($search)) {
        $query->where('name', 'LIKE', "%{$search}%");
    }

    if ($paginate) {
        $departments = $query->paginate($perPage, ['id', 'name', 'description', 'status', 'external_id']);

        return response()->json([
            'departments' => $departments->items(),
            'pagination' => [
                'current_page' => $departments->currentPage(),
                'last_page' => $departments->lastPage(),
                'per_page' => $departments->perPage(),
                'total' => $departments->total(),
            ],
            'message' => 'Departments fetched successfully (paginated).',
        ]);
    } else {
        $departments = $query->get(['id', 'name', 'description', 'status', 'external_id']);

        return response()->json([
            'departments' => $departments,
            'message' => 'All departments fetched successfully.',
        ]);
    }
}



public function delete($id)
{
    $department = department::find($id);

    if (!$department) {
        return response()->json(['message' => 'Department not found.'], 404);
    }

    $department->delete();

    return response()->json(['message' => 'Department deleted successfully.']);
}
public function show($id)
{
    $department = department::where('external_id',$id)->first();
    return response()->json(['department' => $department]);
}

public function update(Request $req, $id)
{
    $department = department::where('external_id',$id)->first();
    $validated = $req->validate([
        'name' => 'required|string|max:255',
        'status' => 'required|in:active,inactive',
        'description' => 'nullable|string',
    ]);
        $department->name = $req->name;
        $department->description = $req->description ?? '';
        $department->status = $req->status;
        $department->save();

    return response()->json(['message' => 'Department updated successfully!']);
}
public function places()
{
    return response()->json(place::get());
}
public function getDepartments()
{
    $company_id = session('company_id');

    $departments = department::where('company_id', $company_id)
        ->select('id', 'name')
        ->orderBy('name')
        ->get();

    return response()->json(['departments' => $departments]);
}
}
