<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
   public function up(): void
    {
        Schema::create('custom_field_table_values', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('custom_field_id');
            $table->unsignedBigInteger('row_id');
            $table->unsignedBigInteger('column_id');
            $table->text('value')->nullable();
                 $table->unsignedBigInteger('visitor_id');
              $table->foreignId('visit_id')->constrained('visits')->onDelete('cascade');
               $table->foreign('visitor_id')
                  ->references('id')
                  ->on('visitors')
                  ->onDelete('cascade');
            $table->timestamps();

            $table->foreign('custom_field_id')->references('id')->on('custom_fields')->onDelete('cascade');
            $table->foreign('column_id')->references('id')->on('custom_field_table_columns')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('custom_field_table_values');
    }
};
