<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('user_cookies', function (Blueprint $table) {
          $table->id();
            $table->bigInteger("user_id")->unsigned()->nullable();
            $table->foreign("user_id")->references("id")->on("company_users")->onUpdate("cascade")->onDelete("cascade");
            $table->string('cookie')->nullable();
            $table->date('cookie_expiry')->nullable();
            $table->bigInteger("company_id")->unsigned()->nullable();
            $table->foreign("company_id")->references("id")->on("companies")->onUpdate("cascade")->onDelete("cascade");
            $table->timestamps();
        });
    }
    public function down(): void
    {
        Schema::dropIfExists('user_cookies');
    }
};
