<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('visit_hosts', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('visit_id');
            $table->unsignedBigInteger('host_id');

            $table->timestamps();

            // Foreign key constraints
            $table->foreign('visit_id')
                  ->references('id')
                  ->on('visits')
                  ->onDelete('cascade'); // If a visit is deleted, remove related rows

            $table->foreign('host_id')
                  ->references('id')
                  ->on('company_users')
                  ->onDelete('cascade'); // If a host is deleted, remove related rows

            // Optional: prevent duplicate host for same visit
            $table->unique(['visit_id', 'host_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('visit_hosts');
    }
};
