<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('visits', function (Blueprint $table) {
            // Change duration column from int to string (VARCHAR 20 is usually enough)
            $table->string('duration', 20)->nullable()->change();
        });
    }

    public function down(): void
    {
        Schema::table('visits', function (Blueprint $table) {
            // Revert back to integer if needed
            $table->integer('duration')->nullable()->change();
        });
    }
};
