<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('notifications', function (Blueprint $table) {
            $table->string('subject')->nullable()->after('id');
            $table->string('short_description')->nullable()->after('subject');
            $table->longText('content')->nullable()->after('short_description');
            $table->unsignedBigInteger('receiver_id')->nullable()->after('content');
            $table->string('link', 500)->nullable()->after('receiver_id');
            $table->string('link2', 500)->nullable()->after('link');
            $table->string('seen_status')->nullable()->after('type');
            $table->string('is_received')->nullable()->after('seen_status');
            $table->unsignedBigInteger('visitor_id')->nullable()->after('is_received');

            // Foreign key constraints
            $table->foreign('receiver_id')->references('id')->on('company_users')->onDelete('set null');
            $table->foreign('visitor_id')->references('id')->on('visitors')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('notifications', function (Blueprint $table) {
            // Drop foreign keys first
            $table->dropForeign(['receiver_id']);
            $table->dropForeign(['visitor_id']);

            // Then drop columns
            $table->dropColumn([
                'subject',
                'short_description',
                'content',
                'receiver_id',
                'link',
                'link2',
                'type',
                'seen_status',
                'is_received',
                'visitor_id',
            ]);
        });
    }
};
