<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
    Schema::create('visit_host_responses', function (Blueprint $table) {
    $table->id();
    $table->foreignId('visit_id')->constrained('visits')->onDelete('cascade');
    $table->foreignId('host_id')->constrained('company_users')->onDelete('cascade');
    $table->foreignId('place_id')->constrained('places')->onDelete('cascade');
    $table->string('status')->default('Pending');
    $table->text('response_message')->nullable();
    $table->integer('duration')->default(15);
    $table->timestamp('approval_time')->nullable();
    $table->timestamps();

    $table->unique(['visit_id', 'host_id']);
});

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('visit_host_responses');
    }
};
