<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('visits', function (Blueprint $table) {
            // Add nullable foreign key to places table
            $table->foreignId('place_id')
                  ->nullable()
                  ->constrained('places')
                  ->nullOnDelete()
                  ->after('purpose');

            // Add duration column (in minutes)
            $table->integer('duration')
                  ->nullable()
                  ->comment('Meeting duration in minutes')
                  ->after('place_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('visits', function (Blueprint $table) {
            $table->dropForeign(['place_id']);
            $table->dropColumn(['place_id', 'duration']);
        });
    }
};
