<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('blacklists', function (Blueprint $table) {
            $table->id(); // Primary key
            $table->string('external_id')->nullable()->unique();
            $table->unsignedBigInteger('visitor_id'); // FK → visitors
            $table->unsignedBigInteger('company_id'); // FK → companies
            $table->text('reason')->nullable();
            $table->unsignedBigInteger('added_by')->nullable(); // FK → users
            $table->enum('status', ['active', 'revoked'])->default('active');
            $table->timestamps();

            // Foreign keys
            $table->foreign('visitor_id')->references('id')->on('visitors')->onDelete('cascade');
            $table->foreign('company_id')->references('id')->on('companies')->onDelete('cascade');
            $table->foreign('added_by')->references('id')->on('users')->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('blacklists');
    }
};
