<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('visitor_badges', function (Blueprint $table) {
            $table->id(); // Primary key
            $table->string('external_id')->nullable()->unique();
            $table->unsignedBigInteger('visit_id'); // FK → visits
            $table->string('badge_number')->unique(); // badge or printed code
            $table->timestamp('print_time')->nullable();
            $table->unsignedBigInteger('printed_by')->nullable(); // FK → users
            $table->enum('status', ['printed', 'reprinted', 'revoked'])->default('printed');
            $table->timestamps();

            // Foreign keys
            $table->foreign('visit_id')->references('id')->on('visits')->onDelete('cascade');
            $table->foreign('printed_by')->references('id')->on('users')->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('visitor_badges');
    }
};
