<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('visitors', function (Blueprint $table) {
            $table->id(); 
            $table->string('external_id')->nullable()->unique();
            $table->unsignedBigInteger('company_id'); 
            $table->string('first_name');
                $table->string('last_name');
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->string('photo_path')->nullable(); 
            $table->longText('fingerprint_data')->nullable();
            $table->text('address')->nullable();
            $table->longText('face_id_data')->nullable(); 
            $table->string('organization')->nullable();
            $table->string('blacklisted')->default(NULL); 
            $table->timestamps();

            // Foreign key constraint
            $table->foreign('company_id')
                  ->references('id')
                  ->on('companies')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('visitors');
    }
};
