<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
         Schema::create('companies', function (Blueprint $table) {
            $table->id();
            $table->string("external_id")->unique();
            $table->string("name")->nullable();
            $table->string("email")->unique()->nullable();
            $table->string("phone")->unique()->nullable();
            $table->string("status")->nullable();//approved, processing, pending
            $table->dateTime("registered_at")->nullable();
            $table->string("users_code")->unique()->nullable();
            $table->string("logo",1000)->nullable();
            $table->string("country")->nullable();
            $table->string("city")->nullable();
            $table->string("postal_code")->nullable();
            $table->string("address",400)->nullable();
            $table->longText("description")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('companies');
    }
};
